// title: Basic Animated Sky (00)
// image: sky00.pcx
/*
help: Create 3 sky spheres (with animation) and 1 scene map.
*/

// section: Sky Sphere 0 (night sky)
sky sky00_00_sky
{
// entry: sky image
	type = <sky_stars.pcx>;
// entry: animation speed x
	speed_u = 1.5;
// entry: animation speed y
	speed_v = 0.0;

// entry: scale in X dimention
	scale_x = 0.125;
// entry: scale in y dimention
	scale_y = 0.125;

	flags = dome;

// entry: Layer
	layer = 1;
}

// section: Sky Sphere 1 (day sky)
sky sky00_01_sky
{
// entry: sky image
	type = <sky_blue.pcx>;
// entry: animation speed x
	speed_u = 1.5;
// entry: animation speed y
	speed_v = 0.5;

// entry: scale in X dimention
	scale_x = 1.0;
// entry: scale in y dimention
	scale_y = 1.0;

	flags = dome, visible, transparent;
	alpha = 100;

// entry: Layer
	layer = 2;
}

// section: Sky Sphere 2 (cloud layer)
sky sky00_02_sky
{
// entry: sky image
	type = <sky_cloud.pcx>;
// entry: animation speed x
	speed_u = 3.5;
// entry: animation speed y
	speed_v = 4.0;

// entry: scale in X dimention
	scale_x = 1.0;
// entry: scale in y dimention
	scale_y = 1.0;

	flags = dome,overlay,transparent, visible;  // sky dome, black transparent, alpha
	alpha = 75;

// entry: Layer
	layer = 3;
}

// Section: Nighttime horizon
sky sky00_00_scene
{
// entry: scenemap image
	type = <night_mount.pcx>;

// entry: how much horizon is taken by one image (1 = full 360 degrees)
	scale_x = 0.125;

// entry: rotate along the horizon (pan)
	pan = 0;
// entry: rotate vertically (tilt)
	tilt = -3; // moves it

	flags = scene;	// backdrop scene
// entry: Layer
	layer = 4; // display above sky entities with lower layers
}

// section: Daytime horizon
sky sky00_01_scene
{
// entry: scenemap image
	type = <sky_mount.pcx>;

// entry: how much horizon is taken by one image (1 = full 360 degrees)
	scale_x = 0.125;

// entry: rotate along the horizon (pan)
	pan = 0;
// entry: rotate vertically (tilt)
	tilt = -3; // moves it

	flags = scene,transparent,visible; // backdrop scene, alpha, visible

// entry: Layer
	layer = 5; // display above sky entities with lower layers

	alpha = 100;
}


// ---------------------------------------------------------------------
// Local Vars
var sky00_day_or_night = 1;	// 1 for day, 0 for night, otherwise trans

// ---------------------------------------------------------------------
// Functions

// Desc: transition from daytime (sky01) to nighttime (sky00) in the time
//  given by duration.
function Sky00_Day_To_Night(duration)
{
	var	trans;

	// not day or transitioning
	if(sky00_day_or_night != 1) { return(-1); }

	// turn on night layers
	sky00_00_sky.visible = on;    // nighttime sky
	sky00_00_scene.visible = on;	// nighttime horizon

	if(duration > 0) // make sure duration is valid
	{
		sky00_day_or_night = 0.5;	// flag that we are transitioning

		trans = duration;

		// fade to night
		while(trans > 0)
		{
			sky00_01_sky.alpha = 100*(trans/duration);
			sky00_01_scene.alpha = sky00_01_sky.alpha;
			trans -= time;
			wait(1);
		}

  		sky00_day_or_night = 0; // flag that we are in night mode
	}

	// turn off day layers
	sky00_01_sky.alpha = 0;
	sky00_01_scene.alpha = 0;
	sky00_01_sky.visible = off;
	sky00_01_scene.visible = off;
}

// Desc: transition from nighttime (sky00) to daytime (sky01) in the time
//  given by duration.
function Sky00_Night_To_Day(duration)
{
	var	trans;

	// not night or transitioning
	if(sky00_day_or_night != 0) { return(-1); }

	// turn on day layers
	sky00_01_sky.visible = on;    // nighttime sky
	sky00_01_scene.visible = on;	// nighttime horizon

	// catch invalid values
	if(duration > 0)
	{
		sky00_day_or_night = 0.5;	// flag that we are transitioning

		trans = 0;

		// fade to day
		while(trans < duration)
		{
			sky00_01_sky.alpha = 100*(trans/duration);
			sky00_01_scene.alpha = sky00_01_sky.alpha;
			trans += time;
			wait(1);
		}

  		sky00_day_or_night = 1; // flag that we are in day mode
	}

	sky00_01_sky.alpha = 100;
	sky00_01_scene.alpha = 100;
	// turn off night
	sky00_00_sky.visible = off;
	sky00_00_scene.visible = off;
}


// Desc: Fade the cloud layer from its current alpha to a target alpha in
//  the time given by duration.
function	Sky00_Fade_Clouds(target,duration)
{
	var	trans;
	var	delta;
	var	start;

	// catch invalid values
	if(target < 0) 	{ target = 0; }  	// min alpha
	if(target > 100) 	{ target = 100; }	// max alpha
	if(duration <= 0)                   // duration not valid
	{
		sky00_02_sky.alpha = target;
		return;
	}


	trans = 0;
	start = sky00_02_sky.alpha;
	delta = target - sky00_02_sky.alpha;  // change in alpha

	while(trans < duration)
	{
		sky00_02_sky.alpha = start + delta*(trans/duration);
		trans += time;
		wait(1);
	}
	sky00_02_sky.alpha = target;
}

